% This file computes the THD of the square wave filtered by a band-pass filter with quality factor Q. 
% The THD is given by \sqrt{\sum_{n=2}^\infty\frac{1}{Q^2(2n-1)^4-(2Q^2-1)(2n-1)^2+Q^2}}
% The calculation is carried out in 3 different ways: exact residue-based method, 
% approximate analytic method and brute numerical summation;
% the results are respectively denoted by THD_ex,THD_ap and THD_num.
%
% Author: Iaroslav V. Blagouchine, first version of this file was written in August 2010.   

function [THD_ex,THD_ap,THD_num]=thdrscomputing(Q,nmax)

if nargin<1
	Q=0.51;
end

if nargin<2
	nmax=1e3; % Precision of the numerical method, but also computing time...
end


% Exact analytic computation of theTHD via analytical method of residues
% Aux. constant mu:
mu=sqrt(1-1./(2*Q^2)+sqrt((1-4*Q^2)./(4*Q^4)));
% The THD itself
THD_ex=sqrt((pi/(2*sqrt(4*Q^2-1)))*imag((sin(pi*mu))/(mu*(1+cos(pi*mu))) ) - 1);


% Approximate computation of theTHD (approximate analytical method).
THD_ap=(sqrt((pi^2)/3-3))/(4*Q);


% Computation via direct numeric summation
for k=2:nmax
	f(k,:)=1/(Q^2*(2*k-1)^4 - (2*Q^2-1)*(2*k-1)^2+Q^2);
end
THD_num=sqrt(sum(f,1));


